/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.microsoft_office365.service;

import io.micrometer.core.instrument.Counter;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import javax.inject.Named;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.Office365RestClient;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.Office365SourceConfig;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.configuration.Office365ItemInfo;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.models.AuditLogsResponse;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.utils.Constants;
import org.opensearch.dataprepper.plugins.source.source_crawler.model.ItemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class Office365Service {
    private static final Logger log = LoggerFactory.getLogger(Office365Service.class);
    private final Office365SourceConfig office365SourceConfig;
    private final Office365RestClient office365RestClient;
    private final Counter searchResultsFoundCounter;
    private final Counter sevenDayLimitHitCounter;
    private final Counter daysAdjustedCounter;
    private final Counter windowRetryCounter;
    private static final String CONTENT_ID_KEY = "contentId";
    private static final String CONTENT_CREATED_KEY = "contentCreated";
    private static final String CONTENT_URI_KEY = "contentUri";
    private static final String TYPE_KEY = "type";
    private static final Duration TIME_WINDOW = Duration.ofHours(1L);
    private static final Duration RETRY_DELAY = Duration.ofSeconds(1L);

    public Office365Service(Office365SourceConfig office365SourceConfig, Office365RestClient office365RestClient, PluginMetrics pluginMetrics) {
        this.office365SourceConfig = office365SourceConfig;
        this.office365RestClient = office365RestClient;
        this.searchResultsFoundCounter = pluginMetrics.counter("searchResultsFound");
        this.sevenDayLimitHitCounter = pluginMetrics.counter("sevenDayLimitHit");
        this.daysAdjustedCounter = pluginMetrics.counter("daysAdjusted");
        this.windowRetryCounter = pluginMetrics.counter("windowRetry");
    }

    public void initializeSubscriptions() {
        this.office365RestClient.startSubscriptions();
    }

    public void getOffice365Entities(Instant timestamp, Queue<ItemInfo> itemInfoQueue) {
        log.trace("Started to fetch entities");
        this.searchForNewLogs(timestamp, itemInfoQueue);
        log.trace("Creating item information and adding in queue");
    }

    public String getAuditLog(String contentId) {
        return this.office365RestClient.getAuditLog(contentId);
    }

    private void searchForNewLogs(Instant timestamp, Queue<ItemInfo> itemInfoQueue) {
        Instant endTime = Instant.now();
        log.info("Searching for logs between {} and {}", (Object)timestamp, (Object)endTime);
        Instant startTime = timestamp;
        Instant sevenDaysAgo = endTime.minus(Duration.ofDays(7L));
        if (startTime.isBefore(sevenDaysAgo)) {
            long daysAdjusted = Duration.between(startTime, sevenDaysAgo).toDays();
            this.sevenDayLimitHitCounter.increment();
            this.daysAdjustedCounter.increment((double)daysAdjusted);
            log.warn("Adjusting start time from {} to {} ({} days beyond 7-day limit)", new Object[]{startTime, sevenDaysAgo, daysAdjusted});
            startTime = sevenDaysAgo;
        }
        while (startTime.isBefore(endTime)) {
            Instant windowEnd = startTime.plus(TIME_WINDOW);
            if (windowEnd.isAfter(endTime)) {
                windowEnd = endTime;
            }
            log.debug("Processing time window: {} to {}", (Object)startTime, (Object)windowEnd);
            boolean windowSuccessful = true;
            block5: for (String contentType : Constants.CONTENT_TYPES) {
                String nextPageUri = null;
                try {
                    AuditLogsResponse response;
                    while ((response = this.office365RestClient.searchAuditLogs(contentType, startTime, windowEnd, nextPageUri)).getItems() != null && !response.getItems().isEmpty()) {
                        this.addItemsToQueue(response.getItems(), contentType, itemInfoQueue);
                        nextPageUri = response.getNextPageUri();
                        if (nextPageUri != null) continue;
                        continue block5;
                    }
                }
                catch (Exception e) {
                    log.error(DataPrepperMarkers.NOISY, "Failed to fetch logs for time window {} to {} for content type {}. Will retry this window.", new Object[]{startTime, windowEnd, contentType, e});
                    windowSuccessful = false;
                    this.windowRetryCounter.increment();
                    break;
                }
            }
            if (windowSuccessful) {
                log.trace("Successfully completed time window: {} to {}, moving to next window", (Object)startTime, (Object)windowEnd);
                startTime = windowEnd;
                continue;
            }
            log.error("Failed to complete time window: {} to {}, retrying after delay", (Object)startTime, (Object)windowEnd);
            try {
                Thread.sleep(RETRY_DELAY.toMillis());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting to retry time window", ie);
            }
        }
    }

    private void addItemsToQueue(List<Map<String, Object>> items, String contentType, Queue<ItemInfo> itemInfoQueue) {
        items.forEach(item -> {
            Office365ItemInfo itemInfo = Office365ItemInfo.builder().itemId((String)item.get(CONTENT_ID_KEY)).eventTime(Instant.parse((String)item.get(CONTENT_CREATED_KEY))).partitionKey(contentType + String.valueOf(UUID.randomUUID())).metadata((Map<String, Object>)item).keyAttributes(Map.of(TYPE_KEY, contentType, CONTENT_URI_KEY, item.get(CONTENT_URI_KEY))).lastModifiedAt(Instant.now()).build();
            itemInfoQueue.add(itemInfo);
        });
        this.searchResultsFoundCounter.increment((double)items.size());
    }
}

