/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.event_json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.configuration.DataPrepperVersion;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.plugins.codec.event_json.EventJsonOutputCodecConfig;

@DataPrepperPlugin(name="event_json", pluginType=OutputCodec.class, pluginConfigurationType=EventJsonOutputCodecConfig.class)
public class EventJsonOutputCodec
implements OutputCodec {
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    static final String EVENT_JSON = "event_json";
    private static final JsonFactory factory = new JsonFactory();
    private final EventJsonOutputCodecConfig config;
    private JsonGenerator generator;
    private OutputCodecContext codecContext;

    @DataPrepperPluginConstructor
    public EventJsonOutputCodec(EventJsonOutputCodecConfig config) {
        this.config = config;
    }

    public String getExtension() {
        return EVENT_JSON;
    }

    public void start(OutputStream outputStream, Event event, OutputCodecContext context) throws IOException {
        Objects.requireNonNull(outputStream);
        this.generator = factory.createGenerator(outputStream, JsonEncoding.UTF8);
        this.generator.writeStartObject();
        this.generator.writeFieldName("version");
        this.objectMapper.writeValue(this.generator, (Object)DataPrepperVersion.getCurrentVersion().toString());
        this.generator.writeFieldName("events");
        this.generator.writeStartArray();
    }

    public void complete(OutputStream outputStream) throws IOException {
        this.generator.writeEndArray();
        this.generator.writeEndObject();
        this.generator.close();
        outputStream.flush();
        outputStream.close();
    }

    public synchronized void writeEvent(Event event, OutputStream outputStream) throws IOException {
        this.generator.writeStartObject();
        Objects.requireNonNull(event);
        this.getDataMapToSerialize(event);
        this.generator.flush();
        this.generator.writeEndObject();
    }

    private Map<String, Object> getDataMapToSerialize(Event event) throws IOException {
        Map dataMap = event.toMap();
        this.generator.writeFieldName("data");
        this.objectMapper.writeValue(this.generator, (Object)dataMap);
        Map metadataMap = (Map)this.objectMapper.convertValue((Object)event.getMetadata(), Map.class);
        this.generator.writeFieldName("metadata");
        this.objectMapper.writeValue(this.generator, (Object)metadataMap);
        return dataMap;
    }
}

