/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.ml_inference.processor.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.ml_inference.processor.MLProcessor;
import org.opensearch.dataprepper.plugins.ml_inference.processor.MLProcessorConfig;
import org.opensearch.dataprepper.plugins.ml_inference.processor.client.S3ClientFactory;
import org.opensearch.dataprepper.plugins.ml_inference.processor.util.HttpClientExecutor;
import org.opensearch.dataprepper.plugins.ml_inference.processor.util.SdkHttpClientExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.Region;

public class MlCommonRequester {
    private static final Logger LOG = LoggerFactory.getLogger(MLProcessor.class);
    private final Aws4Signer signer;
    private final MLProcessorConfig mlProcessorConfig;
    private final AwsCredentialsSupplier awsCredentialsSupplier;
    private final HttpClientExecutor httpClientExecutor;

    public MlCommonRequester(Aws4Signer signer, MLProcessorConfig mlProcessorConfig, AwsCredentialsSupplier awsCredentialsSupplier) {
        this(signer, mlProcessorConfig, awsCredentialsSupplier, new SdkHttpClientExecutor());
    }

    public MlCommonRequester(Aws4Signer signer, MLProcessorConfig mlProcessorConfig, AwsCredentialsSupplier awsCredentialsSupplier, HttpClientExecutor httpClientExecutor) {
        this.signer = signer;
        this.mlProcessorConfig = mlProcessorConfig;
        this.awsCredentialsSupplier = awsCredentialsSupplier;
        this.httpClientExecutor = httpClientExecutor;
    }

    public void sendRequestToMLCommons(String payload) {
        String host = this.mlProcessorConfig.getHostUrl();
        String modelId = this.mlProcessorConfig.getModelId();
        String path = "/_plugins/_ml/models/" + modelId + "/" + this.mlProcessorConfig.getActionType().getMlCommonsActionValue();
        String url = host + path;
        AwsCredentialsOptions awsCredentialsOptions = S3ClientFactory.convertToCredentialsOptions(this.mlProcessorConfig.getAwsAuthenticationOptions());
        Region region = this.mlProcessorConfig.getAwsAuthenticationOptions().getAwsRegion();
        AwsCredentialsProvider awsCredentialsProvider = this.awsCredentialsSupplier.getProvider(awsCredentialsOptions);
        RequestBody requestBody = RequestBody.fromString((String)payload);
        SdkHttpFullRequest request = SdkHttpFullRequest.builder().method(SdkHttpMethod.POST).uri(URI.create(url)).contentStreamProvider(requestBody.contentStreamProvider()).putHeader("content-type", "application/json").build();
        HttpExecuteRequest executeRequest = HttpExecuteRequest.builder().request((SdkHttpRequest)this.signRequest(request, region, awsCredentialsProvider)).contentStreamProvider((ContentStreamProvider)request.contentStreamProvider().orElse(null)).build();
        this.executeHttpRequest(executeRequest);
    }

    private void executeHttpRequest(HttpExecuteRequest executeRequest) {
        try {
            HttpExecuteResponse response = this.httpClientExecutor.execute(executeRequest);
            this.handleHttpResponse(response);
        }
        catch (IOException e) {
            LOG.error("IOException occurred while executing HTTP request to ML Commons due to {}", (Object)e.getMessage());
            throw new RuntimeException("Failed to execute HTTP request due to IO issue", e);
        }
        catch (Exception e) {
            LOG.error("Error occurred while executing HTTP request to ML Commons. Request details: {}", (Object)executeRequest, (Object)e);
            throw new RuntimeException("Failed to execute HTTP request using the ML Commons model", e);
        }
    }

    private void handleHttpResponse(HttpExecuteResponse response) throws IOException {
        int statusCode = response.httpResponse().statusCode();
        String modelResponse = response.responseBody().map(this::readStream).orElse("No response");
        if (statusCode == 429) {
            LOG.warn("Request was throttled with status code 429: {}", (Object)modelResponse);
            throw new RuntimeException("Request was throttled with status code 429: " + modelResponse);
        }
        if (statusCode >= 400 && statusCode < 500) {
            LOG.error("Client error occurred with status code {}: {}", (Object)statusCode, (Object)modelResponse);
            throw new RuntimeException("Client error occurred with status code " + statusCode + ": " + modelResponse);
        }
        if (statusCode >= 500 && statusCode < 600) {
            LOG.error("Server error occurred with status code {}: {}", (Object)statusCode, (Object)modelResponse);
            throw new RuntimeException("Server error occurred with status code " + statusCode + ": " + modelResponse);
        }
        if (statusCode != 200) {
            LOG.error("Unexpected status code {}: {}", (Object)statusCode, (Object)modelResponse);
            throw new RuntimeException("Request failed with status code: " + statusCode);
        }
    }

    private String readStream(AbortableInputStream stream) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Failed to read the response from ML Commons", (Throwable)e);
                throw new RuntimeException("Error reading response body", e);
            }
        }
        reader.close();
        return string;
    }

    private SdkHttpFullRequest signRequest(SdkHttpFullRequest request, Region region, AwsCredentialsProvider awsCredentialsProvider) {
        try {
            AwsCredentials credentials = awsCredentialsProvider.resolveCredentials();
            String signingName = "es";
            Aws4SignerParams params = Aws4SignerParams.builder().awsCredentials(credentials).signingName(signingName).signingRegion(region).build();
            return this.signer.sign(request, params);
        }
        catch (Exception e) {
            LOG.error("Failed to sign request due to credential retrieval error", (Throwable)e);
            throw new RuntimeException("Unable to sign AWS request", e);
        }
    }
}

