/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.crowdstrike;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import org.opensearch.dataprepper.plugins.source.crowdstrike.configuration.AuthenticationConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerSourceConfig;

public class CrowdStrikeSourceConfig
implements CrawlerSourceConfig {
    private static final int DEFAULT_NUMBER_OF_WORKERS = 5;
    private static final int DEFAULT_NUMBER_OF_LOOK_BACK_DAYS = 0;
    @JsonProperty(value="authentication")
    @Valid
    protected AuthenticationConfig authenticationConfig;
    @JsonProperty(value="acknowledgments")
    private boolean acknowledgments = false;
    @JsonProperty(value="workers")
    @Min(value=1L)
    @Max(value=50L)
    @Valid
    private @Min(value=1L) @Max(value=50L) @Valid int numberOfWorkers = 5;
    @JsonProperty(value="look_back_days")
    @Min(value=0L)
    @Max(value=90L)
    @Valid
    private @Min(value=0L) @Max(value=90L) @Valid int lookBackDays = 0;

    public AuthenticationConfig getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public boolean isAcknowledgments() {
        return this.acknowledgments;
    }

    public int getNumberOfWorkers() {
        return this.numberOfWorkers;
    }

    public int getLookBackDays() {
        return this.lookBackDays;
    }
}

