/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.splitevent;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.opensearch.dataprepper.model.annotations.AlsoRequired;
import org.opensearch.dataprepper.model.annotations.ConditionalRequired;
import org.opensearch.dataprepper.model.annotations.ValidRegex;

@ConditionalRequired(value={@ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="delimiter", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="delimiter_regex")}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="delimiter_regex", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="delimiter")})})
@JsonPropertyOrder
@JsonClassDescription(value="The <code>split_event</code> processor is used to split events based on a delimiter and generates multiple events from a user-specified field.")
public class SplitEventProcessorConfig {
    static final String DELIMITER_REGEX_KEY = "delimiter_regex";
    @NotEmpty
    @NotNull
    @JsonProperty(value="field")
    @JsonPropertyDescription(value="The event field to be split.")
    private String field;
    @Size(min=1, max=1)
    @JsonPropertyDescription(value="The delimiter character used for splitting the field. You must provide either the <code>delimiter</code> or the <code>delimiter_regex</code>.")
    @AlsoRequired(values={@AlsoRequired.Required(name="delimiter_regex", allowedValues={"null", "\"\""})})
    private @Size(min=1, max=1) String delimiter;
    @ValidRegex(message="The value of delimiter_regex is not a valid regex string")
    @JsonProperty(value="delimiter_regex")
    @JsonPropertyDescription(value="The regular expression used as the delimiter for splitting the field. You must provide either the <code>delimiter</code> or the <code>delimiter_regex</code>.")
    @AlsoRequired(values={@AlsoRequired.Required(name="delimiter", allowedValues={"null", "\"\""})})
    private String delimiterRegex;

    public String getField() {
        return this.field;
    }

    public String getDelimiterRegex() {
        return this.delimiterRegex;
    }

    public String getDelimiter() {
        return this.delimiter;
    }
}

