/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sourcecoordinator.dynamodb;

import java.time.Instant;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStatus;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbBean;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbPartitionKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSecondaryPartitionKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSecondarySortKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSortKey;

@DynamoDbBean
public class DynamoDbSourcePartitionItem
implements SourcePartitionStoreItem {
    private String sourceIdentifier;
    private String sourcePartitionKey;
    private String partitionOwner;
    private Long version;
    private String partitionProgressState;
    private SourcePartitionStatus sourcePartitionStatus;
    private Instant partitionOwnershipTimeout;
    private Instant reOpenAt;
    private Long closedCount;
    private String sourceStatusCombinationKey;
    private String partitionPriority;
    private Long expirationTime;

    @DynamoDbPartitionKey
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    @DynamoDbSortKey
    public String getSourcePartitionKey() {
        return this.sourcePartitionKey;
    }

    @DynamoDbSecondaryPartitionKey(indexNames={"source-status"})
    public String getSourceStatusCombinationKey() {
        return this.sourceStatusCombinationKey;
    }

    @DynamoDbSecondarySortKey(indexNames={"source-status"})
    public String getPartitionPriority() {
        return this.partitionPriority;
    }

    public Long getExpirationTime() {
        return this.expirationTime;
    }

    public String getPartitionOwner() {
        return this.partitionOwner;
    }

    public String getPartitionProgressState() {
        return this.partitionProgressState;
    }

    public SourcePartitionStatus getSourcePartitionStatus() {
        return this.sourcePartitionStatus;
    }

    public Instant getPartitionOwnershipTimeout() {
        return this.partitionOwnershipTimeout;
    }

    public Instant getReOpenAt() {
        return this.reOpenAt;
    }

    public Long getClosedCount() {
        return this.closedCount;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setSourcePartitionKey(String sourcePartitionKey) {
        this.sourcePartitionKey = sourcePartitionKey;
    }

    public void setPartitionOwner(String partitionOwner) {
        this.partitionOwner = partitionOwner;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setPartitionProgressState(String partitionProgressState) {
        this.partitionProgressState = partitionProgressState;
    }

    public void setSourcePartitionStatus(SourcePartitionStatus sourcePartitionStatus) {
        this.sourcePartitionStatus = sourcePartitionStatus;
    }

    public void setPartitionOwnershipTimeout(Instant partitionOwnershipTimeout) {
        this.partitionOwnershipTimeout = partitionOwnershipTimeout;
    }

    public void setReOpenAt(Instant reOpenAt) {
        this.reOpenAt = reOpenAt;
    }

    public void setClosedCount(Long closedCount) {
        this.closedCount = closedCount;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public void setSourceStatusCombinationKey(String sourceStatusCombinationKey) {
        this.sourceStatusCombinationKey = sourceStatusCombinationKey;
    }

    public void setPartitionPriority(String partitionPriority) {
        this.partitionPriority = partitionPriority;
    }

    public void setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
    }
}

