/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetClassifiersRequest;
import software.amazon.awssdk.services.glue.model.GetClassifiersResponse;

public class GetClassifiersPublisher
implements SdkPublisher<GetClassifiersResponse> {
    private final GlueAsyncClient client;
    private final GetClassifiersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetClassifiersPublisher(GlueAsyncClient client, GetClassifiersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetClassifiersPublisher(GlueAsyncClient client, GetClassifiersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetClassifiersResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetClassifiersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetClassifiersResponseFetcher
    implements AsyncPageFetcher<GetClassifiersResponse> {
        private GetClassifiersResponseFetcher() {
        }

        public boolean hasNextPage(GetClassifiersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetClassifiersResponse> nextPage(GetClassifiersResponse previousPage) {
            if (previousPage == null) {
                return GetClassifiersPublisher.this.client.getClassifiers(GetClassifiersPublisher.this.firstRequest);
            }
            return GetClassifiersPublisher.this.client.getClassifiers((GetClassifiersRequest)((Object)GetClassifiersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

