/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ConnectionInput;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateConnectionRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(UpdateConnectionRequest.getter(UpdateConnectionRequest::catalogId)).setter(UpdateConnectionRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateConnectionRequest.getter(UpdateConnectionRequest::name)).setter(UpdateConnectionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<ConnectionInput> CONNECTION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionInput").getter(UpdateConnectionRequest.getter(UpdateConnectionRequest::connectionInput)).setter(UpdateConnectionRequest.setter(Builder::connectionInput)).constructor(ConnectionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, NAME_FIELD, CONNECTION_INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConnectionRequest.memberNameToFieldInitializer();
    private final String catalogId;
    private final String name;
    private final ConnectionInput connectionInput;

    private UpdateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.name = builder.name;
        this.connectionInput = builder.connectionInput;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String name() {
        return this.name;
    }

    public final ConnectionInput connectionInput() {
        return this.connectionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionRequest)) {
            return false;
        }
        UpdateConnectionRequest other = (UpdateConnectionRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.connectionInput(), other.connectionInput());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectionRequest").add("CatalogId", (Object)this.catalogId()).add("Name", (Object)this.name()).add("ConnectionInput", (Object)this.connectionInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ConnectionInput": {
                return Optional.ofNullable(clazz.cast(this.connectionInput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ConnectionInput", CONNECTION_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionRequest, T> g) {
        return obj -> g.apply((UpdateConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String name;
        private ConnectionInput connectionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.name(model.name);
            this.connectionInput(model.connectionInput);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConnectionInput.Builder getConnectionInput() {
            return this.connectionInput != null ? this.connectionInput.toBuilder() : null;
        }

        public final void setConnectionInput(ConnectionInput.BuilderImpl connectionInput) {
            this.connectionInput = connectionInput != null ? connectionInput.build() : null;
        }

        @Override
        public final Builder connectionInput(ConnectionInput connectionInput) {
            this.connectionInput = connectionInput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionRequest build() {
            return new UpdateConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConnectionRequest> {
        public Builder catalogId(String var1);

        public Builder name(String var1);

        public Builder connectionInput(ConnectionInput var1);

        default public Builder connectionInput(Consumer<ConnectionInput.Builder> connectionInput) {
            return this.connectionInput((ConnectionInput)((ConnectionInput.Builder)ConnectionInput.builder().applyMutation(connectionInput)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

