/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.TableOptimizer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchTableOptimizer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchTableOptimizer> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalogId").getter(BatchTableOptimizer.getter(BatchTableOptimizer::catalogId)).setter(BatchTableOptimizer.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(BatchTableOptimizer.getter(BatchTableOptimizer::databaseName)).setter(BatchTableOptimizer.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableName").getter(BatchTableOptimizer.getter(BatchTableOptimizer::tableName)).setter(BatchTableOptimizer.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final SdkField<TableOptimizer> TABLE_OPTIMIZER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tableOptimizer").getter(BatchTableOptimizer.getter(BatchTableOptimizer::tableOptimizer)).setter(BatchTableOptimizer.setter(Builder::tableOptimizer)).constructor(TableOptimizer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableOptimizer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, TABLE_OPTIMIZER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchTableOptimizer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final TableOptimizer tableOptimizer;

    private BatchTableOptimizer(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.tableOptimizer = builder.tableOptimizer;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final TableOptimizer tableOptimizer() {
        return this.tableOptimizer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableOptimizer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchTableOptimizer)) {
            return false;
        }
        BatchTableOptimizer other = (BatchTableOptimizer)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.tableOptimizer(), other.tableOptimizer());
    }

    public final String toString() {
        return ToString.builder((String)"BatchTableOptimizer").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("TableOptimizer", (Object)this.tableOptimizer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "catalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "tableOptimizer": {
                return Optional.ofNullable(clazz.cast(this.tableOptimizer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("catalogId", CATALOG_ID_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("tableName", TABLE_NAME_FIELD);
        map.put("tableOptimizer", TABLE_OPTIMIZER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchTableOptimizer, T> g) {
        return obj -> g.apply((BatchTableOptimizer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private TableOptimizer tableOptimizer;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchTableOptimizer model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.tableOptimizer(model.tableOptimizer);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final TableOptimizer.Builder getTableOptimizer() {
            return this.tableOptimizer != null ? this.tableOptimizer.toBuilder() : null;
        }

        public final void setTableOptimizer(TableOptimizer.BuilderImpl tableOptimizer) {
            this.tableOptimizer = tableOptimizer != null ? tableOptimizer.build() : null;
        }

        @Override
        public final Builder tableOptimizer(TableOptimizer tableOptimizer) {
            this.tableOptimizer = tableOptimizer;
            return this;
        }

        public BatchTableOptimizer build() {
            return new BatchTableOptimizer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchTableOptimizer> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder tableOptimizer(TableOptimizer var1);

        default public Builder tableOptimizer(Consumer<TableOptimizer.Builder> tableOptimizer) {
            return this.tableOptimizer((TableOptimizer)((TableOptimizer.Builder)TableOptimizer.builder().applyMutation(tableOptimizer)).build());
        }
    }
}

