/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.ExampleValues;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>select_entries</code> processor selects entries from an event.")
public class SelectEntriesProcessorConfig {
    @NotEmpty
    @NotNull
    @JsonProperty(value="include_keys")
    @JsonPropertyDescription(value="A list of keys to be selected from an event.")
    private List<String> includeKeys;
    @JsonProperty(value="select_when")
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a>, such as <code>/some-key == \"test\"</code>, that will be evaluated to determine whether the processor will be run on the event. Default is <code>null</code>. All events will be processed unless otherwise stated.")
    @ExampleValues(value={@ExampleValues.Example(value="/some-key == test", description="Only runs the select_entries processor on the Event if some_key is 'test'.")})
    private String selectWhen;

    public List<String> getIncludeKeys() {
        return this.includeKeys;
    }

    public String getSelectWhen() {
        return this.selectWhen;
    }
}

