/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.ExampleValues;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>map_to_list</code> processor converts a map of key-value pairs to a list of objects. Each object contains the key and value in separate fields.")
public class MapToListProcessorConfig {
    private static final String DEFAULT_KEY_NAME = "key";
    private static final String DEFAULT_VALUE_NAME = "value";
    private static final List<String> DEFAULT_EXCLUDE_KEYS = new ArrayList<String>();
    private static final boolean DEFAULT_REMOVE_PROCESSED_FIELDS = false;
    @NotNull
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="The source map used to perform the mapping operation. When set to an empty string (<code>\"\"</code>), it will use the root of the event as the <code>source</code>.")
    private String source;
    @NotEmpty
    @NotNull
    @JsonProperty(value="target")
    @JsonPropertyDescription(value="The target for the generated list.")
    private String target;
    @JsonProperty(value="key_name", defaultValue="key")
    @JsonPropertyDescription(value="The name of the field in which to store the original key. Default is <code>key</code>.")
    @ExampleValues(value={@ExampleValues.Example(value="og_key", description="The original key in the map is stored in 'og_key' in the list.")})
    private String keyName = "key";
    @JsonProperty(value="value_name", defaultValue="value")
    @JsonPropertyDescription(value="The name of the field in which to store the original value. Default is <code>value</code>.")
    @ExampleValues(value={@ExampleValues.Example(value="og_value", description="The original value in the map is stored in 'og_value' in the list.")})
    private String valueName = "value";
    @JsonProperty(value="remove_processed_fields")
    @JsonPropertyDescription(value="When <code>true</code>, the processor will remove the processed fields from the source map. Default is <code>false</code>.")
    private boolean removeProcessedFields = false;
    @JsonProperty(value="convert_field_to_list")
    @JsonPropertyDescription(value="If <code>true</code>, the processor will convert the fields from the source map into lists and place them in fields in the target list. Default is <code>false</code>.")
    private boolean convertFieldToList = false;
    @JsonProperty(value="exclude_keys")
    @JsonPropertyDescription(value="The keys in the source map that will be excluded from processing. Default is an empty list (<code>[]</code>).")
    private List<String> excludeKeys = DEFAULT_EXCLUDE_KEYS;
    @JsonProperty(value="tags_on_failure")
    @JsonPropertyDescription(value="A list of tags to add to the event metadata when the event fails to process.")
    private List<String> tagsOnFailure;
    @JsonProperty(value="map_to_list_when")
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a>, such as <code>/some-key == \"test\"</code>, that will be evaluated to determine whether the processor will be run on the event. By default, all events will be processed unless otherwise stated.")
    @ExampleValues(value={@ExampleValues.Example(value="/some-key == \"test\"", description="When the key is 'test', the processor will be applied to the event.")})
    private String mapToListWhen;

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getValueName() {
        return this.valueName;
    }

    public String getMapToListWhen() {
        return this.mapToListWhen;
    }

    public List<String> getExcludeKeys() {
        return this.excludeKeys;
    }

    public boolean getRemoveProcessedFields() {
        return this.removeProcessedFields;
    }

    public boolean getConvertFieldToList() {
        return this.convertFieldToList;
    }

    public List<String> getTagsOnFailure() {
        return this.tagsOnFailure;
    }
}

