/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.mutateevent.CopyValueProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="copy_values", pluginType=Processor.class, pluginConfigurationType=CopyValueProcessorConfig.class)
public class CopyValueProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(CopyValueProcessor.class);
    private final CopyValueProcessorConfig config;
    private final List<CopyValueProcessorConfig.Entry> entries;
    private final ExpressionEvaluator expressionEvaluator;

    @DataPrepperPluginConstructor
    public CopyValueProcessor(PluginMetrics pluginMetrics, CopyValueProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.config = config;
        this.entries = config.getEntries();
        this.expressionEvaluator = expressionEvaluator;
        config.getEntries().forEach(entry -> {
            if (entry.getCopyWhen() != null && !expressionEvaluator.isValidExpressionStatement(entry.getCopyWhen()).booleanValue()) {
                throw new InvalidPluginConfigurationException(String.format("copy_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getCopyWhen()));
            }
        });
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            try {
                if (this.config.getFromList() != null || this.config.getToList() != null) {
                    if (recordEvent.containsKey(this.config.getToList()) && !this.config.getOverwriteIfToListExists()) continue;
                    List sourceList = (List)recordEvent.get(this.config.getFromList(), List.class);
                    ArrayList targetList = new ArrayList();
                    HashMap<CopyValueProcessorConfig.Entry, Boolean> whenConditions = new HashMap<CopyValueProcessorConfig.Entry, Boolean>();
                    for (CopyValueProcessorConfig.Entry entry : this.entries) {
                        if (Objects.nonNull(entry.getCopyWhen()) && !this.expressionEvaluator.evaluateConditional(entry.getCopyWhen(), recordEvent).booleanValue()) {
                            whenConditions.put(entry, Boolean.FALSE);
                            continue;
                        }
                        whenConditions.put(entry, Boolean.TRUE);
                    }
                    Iterator<CopyValueProcessorConfig.Entry> iterator = sourceList.iterator();
                    while (iterator.hasNext()) {
                        Map sourceField = (Map)((Object)iterator.next());
                        HashMap targetItem = new HashMap();
                        for (CopyValueProcessorConfig.Entry entry : this.entries) {
                            if (!((Boolean)whenConditions.get(entry)).booleanValue() || !sourceField.containsKey(entry.getFromKey())) continue;
                            targetItem.put(entry.getToKey(), sourceField.get(entry.getFromKey()));
                        }
                        targetList.add(targetItem);
                    }
                    recordEvent.put(this.config.getToList(), targetList);
                    continue;
                }
                for (CopyValueProcessorConfig.Entry entry : this.entries) {
                    if (!this.shouldCopyEntry(entry, recordEvent)) continue;
                    Object source = recordEvent.get(entry.getFromKey(), Object.class);
                    recordEvent.put(entry.getToKey(), source);
                }
            }
            catch (Exception e) {
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("There was an exception while processing Event [{}]").addArgument((Object)recordEvent).setCause((Throwable)e).log();
            }
        }
        return records;
    }

    private boolean shouldCopyEntry(CopyValueProcessorConfig.Entry entry, Event recordEvent) {
        if (Objects.nonNull(entry.getCopyWhen()) && !this.expressionEvaluator.evaluateConditional(entry.getCopyWhen(), recordEvent).booleanValue()) {
            return false;
        }
        if (entry.getFromKey().equals(entry.getToKey()) || !recordEvent.containsKey(entry.getFromKey())) {
            return false;
        }
        return !recordEvent.containsKey(entry.getToKey()) || entry.getOverwriteIfToKeyExists();
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

