/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.server.grpc.DefaultHttpJsonTranscodingOptions;
import com.linecorp.armeria.server.grpc.HttpJsonTranscodingOptions;
import com.linecorp.armeria.server.grpc.HttpJsonTranscodingQueryParamMatchRule;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandler;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

@UnstableApi
public final class HttpJsonTranscodingOptionsBuilder {
    private static final EnumSet<HttpJsonTranscodingQueryParamMatchRule> DEFAULT_QUERY_PARAM_MATCH_RULES = EnumSet.of(HttpJsonTranscodingQueryParamMatchRule.ORIGINAL_FIELD);
    private UnframedGrpcErrorHandler errorHandler = UnframedGrpcErrorHandler.ofJson();
    @Nullable
    private Set<HttpJsonTranscodingQueryParamMatchRule> queryParamMatchRules;

    HttpJsonTranscodingOptionsBuilder() {
    }

    public HttpJsonTranscodingOptionsBuilder queryParamMatchRules(HttpJsonTranscodingQueryParamMatchRule ... queryParamMatchRules) {
        Objects.requireNonNull(queryParamMatchRules, "queryParamMatchRules");
        this.queryParamMatchRules((Iterable<HttpJsonTranscodingQueryParamMatchRule>)ImmutableList.copyOf((Object[])queryParamMatchRules));
        return this;
    }

    public HttpJsonTranscodingOptionsBuilder queryParamMatchRules(Iterable<HttpJsonTranscodingQueryParamMatchRule> queryParamMatchRules) {
        Objects.requireNonNull(queryParamMatchRules, "queryParamMatchRules");
        Preconditions.checkArgument((!Iterables.isEmpty(queryParamMatchRules) ? 1 : 0) != 0, (Object)"Can't set an empty queryParamMatchRules");
        if (this.queryParamMatchRules == null) {
            this.queryParamMatchRules = EnumSet.noneOf(HttpJsonTranscodingQueryParamMatchRule.class);
        }
        this.queryParamMatchRules.addAll((Collection<HttpJsonTranscodingQueryParamMatchRule>)ImmutableList.copyOf(queryParamMatchRules));
        return this;
    }

    @UnstableApi
    public HttpJsonTranscodingOptionsBuilder errorHandler(UnframedGrpcErrorHandler errorHandler) {
        Objects.requireNonNull(errorHandler, "errorHandler");
        this.errorHandler = errorHandler;
        return this;
    }

    public HttpJsonTranscodingOptions build() {
        ImmutableSet matchRules = this.queryParamMatchRules == null ? DEFAULT_QUERY_PARAM_MATCH_RULES : Sets.immutableEnumSet(this.queryParamMatchRules);
        return new DefaultHttpJsonTranscodingOptions((Set<HttpJsonTranscodingQueryParamMatchRule>)matchRules, this.errorHandler);
    }
}

