/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.HandlerRegistry;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class GrpcDecoratingService
extends SimpleDecoratingHttpService
implements GrpcService {
    private final GrpcService delegate;
    private final HandlerRegistry handlerRegistry;
    @Nullable
    private Map<ServerMethodDefinition<?, ?>, HttpService> decorated;

    GrpcDecoratingService(GrpcService delegate, HandlerRegistry handlerRegistry) {
        super((HttpService)delegate);
        this.delegate = delegate;
        this.handlerRegistry = handlerRegistry;
    }

    public void serviceAdded(ServiceConfig cfg) throws Exception {
        super.serviceAdded(cfg);
        DependencyInjector dependencyInjector = cfg.server().config().dependencyInjector();
        this.decorated = this.handlerRegistry.applyDecorators((HttpService)this.delegate, dependencyInjector);
        for (HttpService decorator : this.decorated.values()) {
            decorator.serviceAdded(cfg);
        }
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        assert (this.decorated != null);
        ServerMethodDefinition<?, ?> methodDefinition = this.methodDefinition(ctx);
        if (methodDefinition == null) {
            return this.delegate.serve(ctx, req);
        }
        HttpService decoratedService = this.decorated.get(methodDefinition);
        if (decoratedService != null) {
            return decoratedService.serve(ctx, req);
        }
        return this.delegate.serve(ctx, req);
    }

    @VisibleForTesting
    HandlerRegistry handlerRegistry() {
        return this.handlerRegistry;
    }

    public Set<Route> routes() {
        return this.delegate.routes();
    }

    @Override
    public boolean isFramed() {
        return this.delegate.isFramed();
    }

    @Override
    public List<ServerServiceDefinition> services() {
        return this.delegate.services();
    }

    @Override
    public ServerMethodDefinition<?, ?> methodDefinition(ServiceRequestContext ctx) {
        return this.delegate.methodDefinition(ctx);
    }

    @Override
    public Map<String, ServerMethodDefinition<?, ?>> methods() {
        return this.delegate.methods();
    }

    @Override
    public Map<Route, ServerMethodDefinition<?, ?>> methodsByRoute() {
        return this.delegate.methodsByRoute();
    }

    @Override
    public Set<SerializationFormat> supportedSerializationFormats() {
        return this.delegate.supportedSerializationFormats();
    }
}

