/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunction;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.grpc.StatusExceptionConverter;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Objects;

public final class UnwrappingGrpcExceptionHandleFunction
implements GrpcExceptionHandlerFunction {
    private final GrpcExceptionHandlerFunction delegate;

    public UnwrappingGrpcExceptionHandleFunction(GrpcExceptionHandlerFunction handlerFunction) {
        this.delegate = handlerFunction;
    }

    @Override
    @Nullable
    public Status apply(RequestContext ctx, Throwable cause, Metadata metadata) {
        Throwable t = UnwrappingGrpcExceptionHandleFunction.peelAndUnwrap(cause);
        return this.delegate.apply(ctx, t, metadata);
    }

    private static Throwable peelAndUnwrap(Throwable t) {
        Objects.requireNonNull(t, "t");
        for (Throwable cause = Exceptions.peel((Throwable)t); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ArmeriaStatusException)) continue;
            return StatusExceptionConverter.toGrpc((ArmeriaStatusException)cause);
        }
        return t;
    }
}

