/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.grpc.GrpcClientStubFactory;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.client.grpc.GrpcClientFactoryUtil;
import com.linecorp.armeria.internal.client.grpc.ServiceDescriptorResolutionException;
import io.grpc.Channel;
import io.grpc.ServiceDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReactorGrpcClientStubFactory
implements GrpcClientStubFactory {
    @Override
    public ServiceDescriptor findServiceDescriptor(Class<?> clientType) {
        String clientTypeName = clientType.getName();
        if (!clientTypeName.endsWith("Stub")) {
            return null;
        }
        try {
            Class<?> enclosingClass = clientType.getDeclaredField("delegateStub").getType().getEnclosingClass();
            Method getServiceDescriptorMethod = enclosingClass.getDeclaredMethod("getServiceDescriptor", new Class[0]);
            return (ServiceDescriptor)getServiceDescriptorMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServiceDescriptorResolutionException(this.getClass().getSimpleName(), Exceptions.peel((Throwable)e));
        }
    }

    @Override
    public Object newClientStub(Class<?> clientType, Channel channel) {
        Method stubFactoryMethod = GrpcClientFactoryUtil.findStubFactoryMethod(clientType);
        try {
            return stubFactoryMethod.invoke(null, channel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GrpcClientFactoryUtil.newClientStubCreationException(e);
        }
    }
}

