/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.environment;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.config.Configuration;
import software.amazon.cloudwatchlogs.emf.environment.Environment;
import software.amazon.cloudwatchlogs.emf.sinks.AgentSink;
import software.amazon.cloudwatchlogs.emf.sinks.Endpoint;
import software.amazon.cloudwatchlogs.emf.sinks.ISink;
import software.amazon.cloudwatchlogs.emf.sinks.SocketClientFactory;
import software.amazon.cloudwatchlogs.emf.sinks.retry.FibonacciRetryStrategy;

public abstract class AgentBasedEnvironment
implements Environment {
    private static final Logger log = LoggerFactory.getLogger(AgentBasedEnvironment.class);
    private final Configuration config;
    private ISink sink;

    public AgentBasedEnvironment(Configuration config) {
        this.config = config;
    }

    @Override
    public String getName() {
        if (!this.config.getServiceName().isPresent()) {
            log.warn("Unknown ServiceName.");
            return "Unknown";
        }
        return this.config.getServiceName().get();
    }

    @Override
    public String getLogGroupName() {
        return this.config.getLogGroupName().orElse(this.getName() + "-metrics");
    }

    public String getLogStreamName() {
        return this.config.getLogStreamName().orElse("");
    }

    @Override
    public ISink getSink() {
        if (this.sink == null) {
            Endpoint endpoint;
            if (!this.config.getAgentEndpoint().isPresent()) {
                log.info("Endpoint is not defined. Using default: {}", (Object)Endpoint.DEFAULT_TCP_ENDPOINT);
                endpoint = Endpoint.DEFAULT_TCP_ENDPOINT;
            } else {
                endpoint = Endpoint.fromURL(this.config.getAgentEndpoint().get());
            }
            this.sink = new AgentSink(this.getLogGroupName(), this.getLogStreamName(), endpoint, new SocketClientFactory(), this.config.getAsyncBufferSize(), () -> new FibonacciRetryStrategy(50, 2000, 20));
        }
        return this.sink;
    }
}

