/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model;

import java.util.List;

public class NoSearchContextSearchRequest {
    private final String index;
    private final List<String> searchAfter;
    private final Integer paginationSize;

    private NoSearchContextSearchRequest(Builder builder) {
        this.index = builder.index;
        this.searchAfter = builder.searchAfter;
        this.paginationSize = builder.paginationSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIndex() {
        return this.index;
    }

    public List<String> getSearchAfter() {
        return this.searchAfter;
    }

    public Integer getPaginationSize() {
        return this.paginationSize;
    }

    public static class Builder {
        private String index;
        private List<String> searchAfter;
        private Integer paginationSize;

        public Builder withPaginationSize(Integer paginationSize) {
            this.paginationSize = paginationSize;
            return this;
        }

        public Builder withSearchAfter(List<String> searchAfter) {
            this.searchAfter = searchAfter;
            return this;
        }

        public Builder withIndex(String index) {
            this.index = index;
            return this;
        }

        public NoSearchContextSearchRequest build() {
            return new NoSearchContextSearchRequest(this);
        }
    }
}

