/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model;

import java.util.List;
import org.opensearch.dataprepper.model.event.Event;

public class CreateScrollResponse {
    private final String scrollId;
    private final Long scrollCreationTime;
    private final List<Event> documents;

    public List<Event> getDocuments() {
        return this.documents;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public Long getScrollCreationTime() {
        return this.scrollCreationTime;
    }

    private CreateScrollResponse(Builder builder) {
        this.scrollId = builder.scrollId;
        this.scrollCreationTime = builder.scrollCreationTime;
        this.documents = builder.documents;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<Event> documents;
        private String scrollId;
        private Long scrollCreationTime;

        public Builder withDocuments(List<Event> documents) {
            this.documents = documents;
            return this;
        }

        public Builder withScrollId(String scrollId) {
            this.scrollId = scrollId;
            return this;
        }

        public Builder withCreationTime(Long scrollCreationTime) {
            this.scrollCreationTime = scrollCreationTime;
            return this;
        }

        public CreateScrollResponse build() {
            return new CreateScrollResponse(this);
        }
    }
}

