/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.worker;

import com.google.common.math.LongMath;
import com.google.common.primitives.Longs;
import java.time.Duration;
import java.util.Random;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartition;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchIndexProgressState;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchSourceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerCommonUtils {
    private static final Random RANDOM = new Random();
    private static final Logger LOG = LoggerFactory.getLogger(WorkerCommonUtils.class);
    static final Duration BACKOFF_ON_EXCEPTION = Duration.ofSeconds(60L);
    static final long DEFAULT_CHECKPOINT_INTERVAL_MILLS = 300000L;
    static final Duration ACKNOWLEDGEMENT_SET_TIMEOUT = Duration.ofMinutes(20L);
    static final Duration STARTING_BACKOFF = Duration.ofMillis(500L);
    static final Duration MAX_BACKOFF = Duration.ofSeconds(60L);
    static final int BACKOFF_RATE = 2;
    static final Duration MAX_JITTER = Duration.ofSeconds(2L);
    static final Duration MIN_JITTER = Duration.ofSeconds(-2L);

    static AcknowledgementSet createAcknowledgmentSet(AcknowledgementSetManager acknowledgementSetManager, OpenSearchSourceConfiguration openSearchSourceConfiguration, SourceCoordinator<OpenSearchIndexProgressState> sourceCoordinator, SourcePartition<OpenSearchIndexProgressState> indexPartition) {
        AcknowledgementSet acknowledgementSet = null;
        if (openSearchSourceConfiguration.isAcknowledgmentsEnabled().booleanValue()) {
            acknowledgementSet = acknowledgementSetManager.create(result -> {
                if (result.booleanValue()) {
                    sourceCoordinator.closePartition(indexPartition.getPartitionKey(), openSearchSourceConfiguration.getSchedulingParameterConfiguration().getInterval(), openSearchSourceConfiguration.getSchedulingParameterConfiguration().getIndexReadCount(), Boolean.valueOf(true));
                    LOG.info("Received acknowledgment of completion from sink for index {}", (Object)indexPartition.getPartitionKey());
                } else {
                    sourceCoordinator.giveUpPartition(indexPartition.getPartitionKey());
                }
            }, ACKNOWLEDGEMENT_SET_TIMEOUT);
        }
        return acknowledgementSet;
    }

    static void completeIndexPartition(OpenSearchSourceConfiguration openSearchSourceConfiguration, AcknowledgementSet acknowledgementSet, SourcePartition<OpenSearchIndexProgressState> indexPartition, SourceCoordinator<OpenSearchIndexProgressState> sourceCoordinator) {
        if (openSearchSourceConfiguration.isAcknowledgmentsEnabled().booleanValue()) {
            sourceCoordinator.updatePartitionForAcknowledgmentWait(indexPartition.getPartitionKey(), ACKNOWLEDGEMENT_SET_TIMEOUT);
            acknowledgementSet.complete();
        } else {
            sourceCoordinator.closePartition(indexPartition.getPartitionKey(), openSearchSourceConfiguration.getSchedulingParameterConfiguration().getInterval(), openSearchSourceConfiguration.getSchedulingParameterConfiguration().getIndexReadCount(), Boolean.valueOf(false));
            LOG.info("Completed processing of index {}", (Object)indexPartition.getPartitionKey());
        }
    }

    static long calculateExponentialBackoffAndJitter(int retryCount) {
        long jitterMillis = MIN_JITTER.toMillis() + (long)RANDOM.nextInt((int)(MAX_JITTER.toMillis() - MIN_JITTER.toMillis() + 1L));
        return Math.max(1L, Longs.min((long[])new long[]{STARTING_BACKOFF.toMillis() * LongMath.pow((long)2L, (int)((int)Longs.min((long[])new long[]{retryCount - 1, 10L}))) + jitterMillis, MAX_BACKOFF.toMillis()}));
    }
}

