/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import org.opensearch.dataprepper.metrics.PluginMetrics;

public class OpenSearchSourcePluginMetrics {
    static final String DOCUMENTS_PROCESSED = "documentsProcessed";
    static final String INDICES_PROCESSED = "indicesProcessed";
    static final String INDEX_PROCESSING_TIME_ELAPSED = "indexProcessingTime";
    static final String PROCESSING_ERRORS = "processingErrors";
    static final String BYTES_RECEIVED = "bytesReceived";
    static final String BYTES_PROCESSED = "bytesProcessed";
    static final String CREDENTIALS_CHANGED = "credentialsChanged";
    static final String CLIENT_REFRESH_ERRORS = "clientRefreshErrors";
    private final Counter documentsProcessedCounter;
    private final Counter indicesProcessedCounter;
    private final Counter processingErrorsCounter;
    private final Timer indexProcessingTimeTimer;
    private final DistributionSummary bytesReceivedSummary;
    private final DistributionSummary bytesProcessedSummary;
    private final Counter credentialsChangeCounter;
    private final Counter clientRefreshErrorsCounter;

    public static OpenSearchSourcePluginMetrics create(PluginMetrics pluginMetrics) {
        return new OpenSearchSourcePluginMetrics(pluginMetrics);
    }

    private OpenSearchSourcePluginMetrics(PluginMetrics pluginMetrics) {
        this.documentsProcessedCounter = pluginMetrics.counter(DOCUMENTS_PROCESSED);
        this.indicesProcessedCounter = pluginMetrics.counter(INDICES_PROCESSED);
        this.processingErrorsCounter = pluginMetrics.counter(PROCESSING_ERRORS);
        this.indexProcessingTimeTimer = pluginMetrics.timer(INDEX_PROCESSING_TIME_ELAPSED);
        this.bytesReceivedSummary = pluginMetrics.summary(BYTES_RECEIVED);
        this.bytesProcessedSummary = pluginMetrics.summary(BYTES_PROCESSED);
        this.credentialsChangeCounter = pluginMetrics.counter(CREDENTIALS_CHANGED);
        this.clientRefreshErrorsCounter = pluginMetrics.counter(CLIENT_REFRESH_ERRORS);
    }

    public Counter getDocumentsProcessedCounter() {
        return this.documentsProcessedCounter;
    }

    public Counter getIndicesProcessedCounter() {
        return this.indicesProcessedCounter;
    }

    public Counter getProcessingErrorsCounter() {
        return this.processingErrorsCounter;
    }

    public Timer getIndexProcessingTimeTimer() {
        return this.indexProcessingTimeTimer;
    }

    public DistributionSummary getBytesReceivedSummary() {
        return this.bytesReceivedSummary;
    }

    public DistributionSummary getBytesProcessedSummary() {
        return this.bytesProcessedSummary;
    }

    public Counter getCredentialsChangeCounter() {
        return this.credentialsChangeCounter;
    }

    public Counter getClientRefreshErrorsCounter() {
        return this.clientRefreshErrorsCounter;
    }
}

