/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotBlank;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchIndex {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchIndex.class);
    @JsonProperty(value="index_name_regex")
    @NotBlank
    private String indexNameRegex;
    @JsonIgnore
    private Pattern indexNamePattern;

    public Pattern getIndexNamePattern() {
        return this.indexNamePattern;
    }

    @AssertTrue(message="The value of index_name_regex is not a valid regex pattern")
    @AssertTrue(message="The value of index_name_regex is not a valid regex pattern") boolean isRegexValid() {
        try {
            this.indexNamePattern = Pattern.compile(this.indexNameRegex);
            return true;
        }
        catch (PatternSyntaxException e) {
            LOG.error("Invalid index_name_regex pattern '{}': {}", (Object)this.indexNameRegex, (Object)e.getMessage());
            return false;
        }
    }
}

