/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.s3;

import java.time.Duration;
import java.util.UUID;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class S3ClientProvider {
    private static final int STS_CLIENT_RETRIES = 10;
    private static final long STS_CLIENT_BASE_BACKOFF_MILLIS = 1000L;
    private static final long STS_CLIENT_MAX_BACKOFF_MILLIS = 60000L;
    private final String awsRegion;
    private final String awsStsRoleArn;
    private final String awsStsExternalId;
    private final ApacheHttpClient.Builder apacheHttpClientBuilder = ApacheHttpClient.builder();

    public S3ClientProvider(String awsRegion, String awsStsRoleArn, String awsStsExternalId) {
        this.awsRegion = awsRegion;
        this.awsStsRoleArn = awsStsRoleArn;
        this.awsStsExternalId = awsStsExternalId;
    }

    public S3Client buildS3Client() {
        AwsCredentialsProvider credentialsProvider = this.buildAwsCredentialsProvider();
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)this.awsRegion))).credentialsProvider(credentialsProvider)).httpClientBuilder((SdkHttpClient.Builder)this.apacheHttpClientBuilder)).build();
    }

    private AwsCredentialsProvider buildAwsCredentialsProvider() {
        Object awsCredentialsProvider = this.awsStsRoleArn != null && !this.awsStsRoleArn.isEmpty() ? ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(this.getStsClient(this.awsRegion))).refreshRequest(this.getAssumeRoleRequest(this.awsStsRoleArn)).build() : DefaultCredentialsProvider.create();
        return awsCredentialsProvider;
    }

    private AssumeRoleRequest getAssumeRoleRequest(String awsStsRoleArn) {
        AssumeRoleRequest.Builder builder = AssumeRoleRequest.builder().roleSessionName("OpenSearch-Sink-S3" + String.valueOf(UUID.randomUUID())).roleArn(awsStsRoleArn);
        if (this.awsStsExternalId != null && !this.awsStsExternalId.isEmpty()) {
            builder = builder.externalId(this.awsStsExternalId);
        }
        return (AssumeRoleRequest)builder.build();
    }

    private StsClient getStsClient(String awsRegion) {
        EqualJitterBackoffStrategy backoffStrategy = EqualJitterBackoffStrategy.builder().baseDelay(Duration.ofMillis(1000L)).maxBackoffTime(Duration.ofMillis(60000L)).build();
        RetryPolicy retryPolicy = RetryPolicy.builder().numRetries(Integer.valueOf(10)).retryCondition(RetryCondition.defaultRetryCondition()).backoffStrategy((BackoffStrategy)backoffStrategy).throttlingBackoffStrategy((BackoffStrategy)backoffStrategy).build();
        ClientOverrideConfiguration clientOverrideConfiguration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy).build();
        return (StsClient)((StsClientBuilder)((StsClientBuilder)((StsClientBuilder)StsClient.builder().overrideConfiguration(clientOverrideConfiguration)).region(Region.of((String)awsRegion))).httpClientBuilder((SdkHttpClient.Builder)this.apacheHttpClientBuilder)).build();
    }
}

