/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.ComposableIndexTemplateStrategy;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplateAPIWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.TemplateStrategy;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.V1TemplateStrategy;

public enum TemplateType {
    V1("v1", V1TemplateStrategy::new),
    INDEX_TEMPLATE("index-template", ComposableIndexTemplateStrategy::new);

    private static final Map<String, TemplateType> TYPE_NAME_MAP;
    private final String name;
    private final Function<IndexTemplateAPIWrapper, TemplateStrategy> factoryFunction;

    private TemplateType(String name, Function<IndexTemplateAPIWrapper, TemplateStrategy> factoryFunction) {
        this.name = name;
        this.factoryFunction = factoryFunction;
    }

    public static TemplateType fromTypeName(String name) {
        return TYPE_NAME_MAP.get(name);
    }

    public TemplateStrategy createTemplateStrategy(IndexTemplateAPIWrapper indexTemplateAPIWrapper) {
        return this.factoryFunction.apply(indexTemplateAPIWrapper);
    }

    public String getTypeName() {
        return this.name;
    }

    static {
        TYPE_NAME_MAP = Arrays.stream(TemplateType.values()).collect(Collectors.toMap(value -> value.name, value -> value));
    }
}

