/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplate;

class LegacyIndexTemplate
implements IndexTemplate {
    public static final String SETTINGS_KEY = "settings";
    private final Map<String, Object> templateMap;

    public LegacyIndexTemplate(Map<String, Object> templateMap) {
        this.templateMap = new HashMap<String, Object>(templateMap);
        if (this.templateMap.containsKey(SETTINGS_KEY)) {
            HashMap copiedSettings = new HashMap((Map)this.templateMap.get(SETTINGS_KEY));
            this.templateMap.put(SETTINGS_KEY, copiedSettings);
        }
    }

    @Override
    public void setTemplateName(String name) {
        this.templateMap.put("name", name);
    }

    @Override
    public void setIndexPatterns(List<String> indexPatterns) {
        this.templateMap.put("index_patterns", indexPatterns);
    }

    @Override
    public void putCustomSetting(String name, Object value) {
        Map settings = (Map)this.templateMap.computeIfAbsent(SETTINGS_KEY, x -> new HashMap());
        settings.put(name, value);
    }

    @Override
    public Optional<Long> getVersion() {
        if (!this.templateMap.containsKey("version")) {
            return Optional.empty();
        }
        Number version = (Number)this.templateMap.get("version");
        return Optional.of(version.longValue());
    }

    Map<String, Object> getTemplateMap() {
        return this.templateMap;
    }
}

