/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.client.Request;
import org.opensearch.client.ResponseException;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.indices.Alias;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.ExistsAliasRequest;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.AbstractIndexManager;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IsmPolicyManagementStrategy;
import org.opensearch.dataprepper.plugins.sink.opensearch.s3.S3FileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;

class IsmPolicyManagement
implements IsmPolicyManagementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(IsmPolicyManagement.class);
    private static final String POLICY_MANAGEMENT_ENDPOINT = "/_opendistro/_ism/policies/";
    public static final String DEFAULT_INDEX_SUFFIX = "-000001";
    private static final String POLICY_FILE_ROOT_KEY = "policy";
    private static final String POLICY_FILE_ISM_TEMPLATE_KEY = "ism_template";
    private static final String S3_PREFIX = "s3://";
    private final RestHighLevelClient restHighLevelClient;
    private final OpenSearchClient openSearchClient;
    private final String policyName;
    private final String policyFile;
    private final String policyFileWithoutIsmTemplate;
    private S3Client s3Client;

    public IsmPolicyManagement(OpenSearchClient openSearchClient, RestHighLevelClient restHighLevelClient, String policyName, String policyFile, String policyFileWithoutIsmTemplate) {
        Preconditions.checkNotNull((Object)restHighLevelClient);
        Preconditions.checkNotNull((Object)openSearchClient);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)policyName));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)policyFile));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)policyFileWithoutIsmTemplate));
        this.openSearchClient = openSearchClient;
        this.restHighLevelClient = restHighLevelClient;
        this.policyName = policyName;
        this.policyFile = policyFile;
        this.policyFileWithoutIsmTemplate = policyFileWithoutIsmTemplate;
    }

    public IsmPolicyManagement(OpenSearchClient openSearchClient, RestHighLevelClient restHighLevelClient, String policyName, String policyFile, S3Client s3Client) {
        Preconditions.checkNotNull((Object)restHighLevelClient);
        Preconditions.checkNotNull((Object)openSearchClient);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)policyName));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)policyFile));
        this.openSearchClient = openSearchClient;
        this.restHighLevelClient = restHighLevelClient;
        this.policyName = policyName;
        this.policyFile = policyFile;
        this.policyFileWithoutIsmTemplate = null;
        this.s3Client = s3Client;
    }

    @Override
    public Optional<String> checkAndCreatePolicy() throws IOException {
        block6: {
            String policyManagementEndpoint = POLICY_MANAGEMENT_ENDPOINT + this.policyName;
            String policyJsonString = this.retrievePolicyJsonString(this.policyFile);
            Request request = this.createPolicyRequestFromFile(policyManagementEndpoint, policyJsonString);
            try {
                this.restHighLevelClient.getLowLevelClient().performRequest(request);
            }
            catch (ResponseException e1) {
                String msg = e1.getMessage();
                if (msg.contains("Invalid field: [ism_template]")) {
                    block5: {
                        policyJsonString = StringUtils.isEmpty((String)this.policyFileWithoutIsmTemplate) ? this.dropIsmTemplateFromPolicy(policyJsonString) : this.retrievePolicyJsonString(this.policyFileWithoutIsmTemplate);
                        request = this.createPolicyRequestFromFile(policyManagementEndpoint, policyJsonString);
                        try {
                            this.restHighLevelClient.getLowLevelClient().performRequest(request);
                        }
                        catch (ResponseException e2) {
                            if (e2.getMessage().contains("version_conflict_engine_exception") || e2.getMessage().contains("resource_already_exists_exception")) break block5;
                            throw e2;
                        }
                    }
                    return Optional.of(this.policyName);
                }
                if (e1.getMessage().contains("version_conflict_engine_exception") || e1.getMessage().contains("resource_already_exists_exception")) break block6;
                throw e1;
            }
        }
        return Optional.empty();
    }

    @Override
    public List<String> getIndexPatterns(String indexAlias) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)indexAlias));
        return Collections.singletonList(AbstractIndexManager.TIME_PATTERN.matcher(indexAlias).replaceAll("*") + "-*");
    }

    @Override
    public boolean checkIfIndexExistsOnServer(String indexAlias) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)indexAlias));
        BooleanResponse booleanResponse = this.openSearchClient.indices().existsAlias(new ExistsAliasRequest.Builder().name(indexAlias, new String[0]).build());
        return booleanResponse.value();
    }

    @Override
    public CreateIndexRequest getCreateIndexRequest(String indexAlias) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)indexAlias));
        String initialIndexName = indexAlias + DEFAULT_INDEX_SUFFIX;
        CreateIndexRequest createIndexRequest = new CreateIndexRequest.Builder().index(initialIndexName).aliases(indexAlias, new Alias.Builder().isWriteIndex(Boolean.valueOf(true)).build()).build();
        return createIndexRequest;
    }

    private String retrievePolicyJsonString(String fileName) throws IOException {
        if (fileName.startsWith(S3_PREFIX)) {
            String ismPolicyJsonString = this.retrievePolicyJsonStringFromS3(fileName);
            if (ismPolicyJsonString != null) {
                return ismPolicyJsonString;
            }
            throw new RuntimeException("Error encountered while processing ISM policy provided from S3.");
        }
        return this.retrievePolicyJsonStringFromFile(fileName);
    }

    private String retrievePolicyJsonStringFromS3(String fileName) throws IOException {
        String ismPolicy = null;
        S3FileReader s3FileReader = new S3FileReader(this.s3Client);
        try (InputStream inputStream = s3FileReader.readFile(fileName);){
            Map stringObjectMap = (Map)new ObjectMapper().readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
            ismPolicy = new ObjectMapper().writeValueAsString((Object)stringObjectMap);
        }
        catch (JsonProcessingException e) {
            LOG.info("Error encountered while processing JSON content in ISM policy file from S3.");
        }
        return ismPolicy;
    }

    private String retrievePolicyJsonStringFromFile(String fileName) throws IOException {
        StringBuilder policyJsonBuffer = new StringBuilder();
        File file = new File(fileName);
        URL policyFileUrl = file.isAbsolute() ? file.toURI().toURL() : this.getClass().getClassLoader().getResource(fileName);
        try (InputStream inputStream = policyFileUrl.openStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(inputStream)));){
            reader.lines().forEach(line -> policyJsonBuffer.append((String)line).append("\n"));
        }
        return policyJsonBuffer.toString();
    }

    private Request createPolicyRequestFromFile(String endPoint, String policyJsonString) {
        Request request = new Request("PUT", endPoint);
        request.setJsonEntity(policyJsonString);
        return request;
    }

    private String dropIsmTemplateFromPolicy(String policyJsonString) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(policyJsonString);
        ((ObjectNode)jsonNode.get(POLICY_FILE_ROOT_KEY)).remove(POLICY_FILE_ISM_TEMPLATE_KEY);
        return jsonNode.toString();
    }
}

