/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch.indices.ExistsIndexTemplateRequest;
import org.opensearch.client.opensearch.indices.GetIndexTemplateRequest;
import org.opensearch.client.opensearch.indices.GetIndexTemplateResponse;
import org.opensearch.client.opensearch.indices.PutIndexTemplateResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.ComposableIndexTemplate;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplate;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplateAPIWrapper;

public class ComposableTemplateAPIWrapper
implements IndexTemplateAPIWrapper<GetIndexTemplateResponse> {
    private final OpenSearchClient openSearchClient;

    public ComposableTemplateAPIWrapper(OpenSearchClient openSearchClient) {
        this.openSearchClient = openSearchClient;
    }

    @Override
    public void putTemplate(IndexTemplate indexTemplate) throws IOException {
        if (!(indexTemplate instanceof ComposableIndexTemplate)) {
            throw new IllegalArgumentException("Unexpected indexTemplate provided to createTemplate.");
        }
        ComposableIndexTemplate composableIndexTemplate = (ComposableIndexTemplate)indexTemplate;
        Map<String, Object> indexTemplateMap = composableIndexTemplate.getIndexTemplateMap();
        ((OpenSearchTransport)this.openSearchClient._transport()).performRequest(indexTemplateMap, this.createEndpoint(composableIndexTemplate), this.openSearchClient._transportOptions());
    }

    @Override
    public Optional<GetIndexTemplateResponse> getTemplate(String indexTemplateName) throws IOException {
        ExistsIndexTemplateRequest existsRequest = new ExistsIndexTemplateRequest.Builder().name(indexTemplateName).build();
        BooleanResponse existsResponse = this.openSearchClient.indices().existsIndexTemplate(existsRequest);
        if (!existsResponse.value()) {
            return Optional.empty();
        }
        GetIndexTemplateRequest getRequest = new GetIndexTemplateRequest.Builder().name(indexTemplateName).build();
        return Optional.of(this.openSearchClient.indices().getIndexTemplate(getRequest));
    }

    private Endpoint<Map<String, Object>, PutIndexTemplateResponse, ErrorResponse> createEndpoint(ComposableIndexTemplate composableIndexTemplate) {
        String path = "/_index_template/" + composableIndexTemplate.getName();
        return new SimpleEndpoint(request -> "PUT", request -> path, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutIndexTemplateResponse._DESERIALIZER);
    }
}

