/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.cluster.GetClusterSettingsRequest;
import org.opensearch.client.opensearch.cluster.GetClusterSettingsResponse;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.ExistsAliasRequest;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.plugins.sink.opensearch.OpenSearchSinkConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.ClusterSettingsParser;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexManager;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplate;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IsmPolicyManagementStrategy;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.TemplateStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexManager
implements IndexManager {
    public static final String INDEX_ALIAS_USED_AS_INDEX_ERROR = "Invalid alias name [%s], an index exists with the same name as the alias";
    public static final String INVALID_INDEX_ALIAS_ERROR = "invalid_index_name_exception";
    static final Set<Integer> NO_ISM_HTTP_STATUS = Set.of(Integer.valueOf(404), Integer.valueOf(400));
    private static final String TIME_PATTERN_STARTING_SYMBOLS = "%{";
    protected RestHighLevelClient restHighLevelClient;
    protected OpenSearchClient openSearchClient;
    protected OpenSearchSinkConfiguration openSearchSinkConfiguration;
    protected ClusterSettingsParser clusterSettingsParser;
    protected IsmPolicyManagementStrategy ismPolicyManagementStrategy;
    private final TemplateStrategy templateStrategy;
    private final String configuredIndexAlias;
    protected String indexPrefix;
    private Boolean isIndexAlias;
    private boolean isIndexAliasChecked;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIndexManager.class);
    private static final String TIME_PATTERN_REGULAR_EXPRESSION = "%\\{.*?\\}";
    static final Pattern TIME_PATTERN = Pattern.compile("%\\{.*?\\}");
    private static final String TIME_PATTERN_INTERNAL_EXTRACTOR_REGULAR_EXPRESSION = "%\\{(.*?)\\}";
    private Optional<DateTimeFormatter> indexDateTimeFormatter;
    private static final ZoneId UTC_ZONE_ID = ZoneId.of(TimeZone.getTimeZone("UTC").getID());
    private static final Set<Character> INVALID_CHARS = ImmutableSet.of((Object)Character.valueOf('#'), (Object)Character.valueOf('\\'), (Object)Character.valueOf('/'), (Object)Character.valueOf('*'), (Object)Character.valueOf('?'), (Object)Character.valueOf('\"'), (Object[])new Character[]{Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf(','), Character.valueOf(':')});
    private static final Set<Character> UNSUPPORTED_TIME_GRANULARITY_CHARS = ImmutableSet.of((Object)Character.valueOf('m'), (Object)Character.valueOf('s'), (Object)Character.valueOf('S'), (Object)Character.valueOf('A'), (Object)Character.valueOf('n'), (Object)Character.valueOf('N'), (Object[])new Character[0]);

    protected AbstractIndexManager(RestHighLevelClient restHighLevelClient, OpenSearchClient openSearchClient, OpenSearchSinkConfiguration openSearchSinkConfiguration, ClusterSettingsParser clusterSettingsParser, TemplateStrategy templateStrategy, String indexAlias) {
        this.templateStrategy = templateStrategy;
        Preconditions.checkNotNull((Object)restHighLevelClient);
        Preconditions.checkNotNull((Object)openSearchClient);
        Preconditions.checkNotNull((Object)openSearchSinkConfiguration);
        Preconditions.checkNotNull((Object)clusterSettingsParser);
        this.restHighLevelClient = restHighLevelClient;
        this.openSearchClient = openSearchClient;
        this.openSearchSinkConfiguration = openSearchSinkConfiguration;
        this.clusterSettingsParser = clusterSettingsParser;
        if (indexAlias == null) {
            indexAlias = openSearchSinkConfiguration.getIndexConfiguration().getIndexAlias();
        }
        this.configuredIndexAlias = indexAlias;
        this.initializeIndexPrefixAndSuffix(indexAlias);
    }

    public static DateTimeFormatter getDatePatternFormatter(String indexAlias) {
        Pattern pattern = Pattern.compile(TIME_PATTERN_INTERNAL_EXTRACTOR_REGULAR_EXPRESSION);
        Matcher timePatternMatcher = pattern.matcher(indexAlias);
        if (timePatternMatcher.find()) {
            String timePattern = timePatternMatcher.group(1);
            if (timePatternMatcher.find()) {
                throw new IllegalArgumentException("An index only allows one date-time pattern.");
            }
            if (timePattern.contains(TIME_PATTERN_STARTING_SYMBOLS)) {
                throw new IllegalArgumentException("An index doesn't allow nested date-time patterns.");
            }
            AbstractIndexManager.validateNoSpecialCharsInTimePattern(timePattern);
            AbstractIndexManager.validateTimePatternGranularity(timePattern);
            return DateTimeFormatter.ofPattern(timePattern);
        }
        return null;
    }

    public static String getIndexAliasWithDate(String indexAlias) {
        DateTimeFormatter dateFormatter = AbstractIndexManager.getDatePatternFormatter(indexAlias);
        String dateTimeString = dateFormatter != null ? dateFormatter.format(AbstractIndexManager.getCurrentUtcTime()) : "";
        return TIME_PATTERN.matcher(indexAlias).replaceAll(dateTimeString);
    }

    private void initializeIndexPrefixAndSuffix(String indexAlias) {
        DateTimeFormatter dateFormatter = AbstractIndexManager.getDatePatternFormatter(indexAlias);
        this.indexDateTimeFormatter = dateFormatter != null ? Optional.of(dateFormatter) : Optional.empty();
        this.indexPrefix = indexAlias.replaceAll("-%\\{.*?\\}", "").replaceAll("%\\{.*?\\}-", "");
    }

    private static void validateNoSpecialCharsInTimePattern(String timePattern) {
        boolean containsInvalidCharacter = timePattern.chars().mapToObj(c -> Character.valueOf((char)c)).anyMatch(character -> INVALID_CHARS.contains(character));
        if (containsInvalidCharacter) {
            throw new IllegalArgumentException("Index time pattern contains one or multiple special characters: " + String.valueOf(INVALID_CHARS));
        }
    }

    private static void validateTimePatternGranularity(String timePattern) {
        boolean containsUnsupportedTimeSymbol = timePattern.chars().mapToObj(c -> Character.valueOf((char)c)).anyMatch(character -> UNSUPPORTED_TIME_GRANULARITY_CHARS.contains(character));
        if (containsUnsupportedTimeSymbol) {
            throw new IllegalArgumentException("Index time pattern contains time patterns that are less than one hour: " + String.valueOf(UNSUPPORTED_TIME_GRANULARITY_CHARS));
        }
    }

    @Override
    public String getIndexName(String dynamicIndexAlias) throws IOException {
        if (this.indexDateTimeFormatter.isPresent()) {
            String formattedTimeString = this.indexDateTimeFormatter.get().format(AbstractIndexManager.getCurrentUtcTime());
            return TIME_PATTERN.matcher(this.configuredIndexAlias).replaceAll(formattedTimeString);
        }
        return this.configuredIndexAlias;
    }

    public static ZonedDateTime getCurrentUtcTime() {
        return LocalDateTime.now().atZone(ZoneId.systemDefault()).withZoneSameInstant(UTC_ZONE_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean isIndexAlias(String dynamicIndexAlias) throws IOException {
        if (!this.isIndexAliasChecked) {
            try {
                this.openSearchClient.info();
                ExistsAliasRequest request = new ExistsAliasRequest.Builder().name(dynamicIndexAlias, new String[0]).build();
                BooleanResponse response = this.openSearchClient.indices().existsAlias(request);
                this.isIndexAlias = response.value() && this.checkISMEnabled();
            }
            catch (RuntimeException ex) {
                this.isIndexAlias = null;
            }
            finally {
                this.isIndexAliasChecked = true;
            }
        }
        return this.isIndexAlias;
    }

    final boolean checkISMEnabled() throws IOException {
        GetClusterSettingsRequest request = new GetClusterSettingsRequest.Builder().includeDefaults(Boolean.valueOf(true)).build();
        try {
            GetClusterSettingsResponse response = this.openSearchClient.cluster().getSettings(request);
            String enabled = this.getISMEnabled(response);
            return enabled != null && enabled.equals("true");
        }
        catch (OpenSearchException ex) {
            if (NO_ISM_HTTP_STATUS.contains(ex.status())) {
                return false;
            }
            throw ex;
        }
    }

    private String getISMEnabled(GetClusterSettingsResponse response) {
        return this.clusterSettingsParser.getStringValueClusterSetting(response, "opendistro.index_state_management.enabled");
    }

    @Override
    public void setupIndex() throws IOException {
        this.checkAndCreateIndexTemplate();
        this.checkAndCreateIndex();
    }

    private void checkAndCreateIndexTemplate() throws IOException {
        Optional<Object> policyIdOptional;
        boolean isISMEnabled = this.checkISMEnabled();
        Optional<Object> optional = policyIdOptional = isISMEnabled ? this.ismPolicyManagementStrategy.checkAndCreatePolicy() : Optional.empty();
        if (!this.openSearchSinkConfiguration.getIndexConfiguration().getIndexTemplate().isEmpty()) {
            this.checkAndCreateIndexTemplate(isISMEnabled, policyIdOptional.orElse(null));
        }
    }

    final void checkAndCreateIndexTemplate(boolean isISMEnabled, String ismPolicyId) throws IOException {
        Map<String, Object> indexTemplateMap;
        IndexTemplate indexTemplate;
        String indexTemplateName = this.indexPrefix + "-index-template";
        if (!this.shouldCreateTemplate(indexTemplateName, indexTemplate = this.templateStrategy.createIndexTemplate(indexTemplateMap = this.openSearchSinkConfiguration.getIndexConfiguration().getIndexTemplate()))) {
            return;
        }
        if (isISMEnabled) {
            this.attachPolicy(indexTemplate, ismPolicyId, this.indexPrefix);
        }
        List<String> indexPatterns = this.ismPolicyManagementStrategy.getIndexPatterns(this.configuredIndexAlias);
        indexTemplate.setTemplateName(indexTemplateName);
        indexTemplate.setIndexPatterns(indexPatterns);
        this.templateStrategy.createTemplate(indexTemplate);
    }

    final Optional<String> checkAndCreatePolicy() throws IOException {
        return this.ismPolicyManagementStrategy.checkAndCreatePolicy();
    }

    public void checkAndCreateIndex() throws IOException {
        block5: {
            String indexAlias = this.getIndexName(null);
            boolean indexExists = this.ismPolicyManagementStrategy.checkIfIndexExistsOnServer(indexAlias);
            if (!indexExists) {
                CreateIndexRequest createIndexRequest = this.ismPolicyManagementStrategy.getCreateIndexRequest(indexAlias);
                try {
                    this.openSearchClient.indices().create(createIndexRequest);
                }
                catch (OpenSearchException e) {
                    if (e.getMessage().contains("resource_already_exists_exception")) break block5;
                    if (e.getMessage().contains(INVALID_INDEX_ALIAS_ERROR)) {
                        throw new InvalidPluginConfigurationException(String.format("Invalid characters in the index name %s", indexAlias));
                    }
                    if (e.getMessage().contains(String.format(INDEX_ALIAS_USED_AS_INDEX_ERROR, indexAlias))) {
                        throw new InvalidPluginConfigurationException(String.format("An index exists with the same name as the reserved index alias name [%s], please delete or migrate the existing index", indexAlias));
                    }
                    throw new IOException(e);
                }
            }
        }
    }

    private boolean shouldCreateTemplate(String templateName, IndexTemplate indexTemplate) throws IOException {
        Optional<Long> optionalExistingVersion = this.templateStrategy.getExistingTemplateVersion(templateName);
        if (optionalExistingVersion.isPresent()) {
            Long existingTemplateVersion = optionalExistingVersion.get();
            LOG.info("Found version {} for existing index template {}", (Object)existingTemplateVersion, (Object)templateName);
            Long newTemplateVersion = indexTemplate.getVersion().orElse(0L);
            if (existingTemplateVersion >= newTemplateVersion) {
                LOG.info("Index template {} should not be updated, current version {} >= existing version {}", new Object[]{templateName, existingTemplateVersion, newTemplateVersion});
                return false;
            }
            LOG.info("Index template {} should be updated from version {} to version {}", new Object[]{templateName, existingTemplateVersion, newTemplateVersion});
            return true;
        }
        LOG.info("Index template {} does not exist and should be created", (Object)templateName);
        return true;
    }

    private void attachPolicy(IndexTemplate indexTemplate, String ismPolicyId, String rolloverAlias) {
        if (ismPolicyId != null) {
            indexTemplate.putCustomSetting("opendistro.index_state_management.policy_id", ismPolicyId);
        }
        indexTemplate.putCustomSetting("opendistro.index_state_management.rollover_alias", rolloverAlias);
    }
}

