/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.bulk;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.SerializedJson;

class SerializedJsonNode
implements SerializedJson,
Serializable {
    private byte[] document;
    private JsonNode jsonNode;
    private String documentId = null;
    private String routingField = null;
    private String pipelineField = null;

    public SerializedJsonNode(JsonNode jsonNode, SerializedJson doc) {
        this.jsonNode = jsonNode;
        this.documentId = doc.getDocumentId().orElse(null);
        this.routingField = doc.getRoutingField().orElse(null);
        this.document = jsonNode.toString().getBytes();
        this.pipelineField = doc.getPipelineField().orElse(null);
    }

    public SerializedJsonNode(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
        this.document = jsonNode.toString().getBytes();
    }

    @Override
    public long getDocumentSize() {
        return this.document.length;
    }

    @Override
    public byte[] getSerializedJson() {
        return this.document;
    }

    @Override
    public Optional<String> getDocumentId() {
        return Optional.ofNullable(this.documentId);
    }

    @Override
    public Optional<String> getRoutingField() {
        return Optional.ofNullable(this.routingField);
    }

    @Override
    public Optional<String> getPipelineField() {
        return Optional.ofNullable(this.pipelineField);
    }
}

