/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch;

import com.google.common.base.Preconditions;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.plugins.sink.opensearch.ConnectionConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.RetryConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.OpenSearchSinkConfig;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexConfiguration;

public class OpenSearchSinkConfiguration {
    private final ConnectionConfiguration connectionConfiguration;
    private final IndexConfiguration indexConfiguration;
    private final RetryConfiguration retryConfiguration;

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public IndexConfiguration getIndexConfiguration() {
        return this.indexConfiguration;
    }

    public RetryConfiguration getRetryConfiguration() {
        return this.retryConfiguration;
    }

    private OpenSearchSinkConfiguration(ConnectionConfiguration connectionConfiguration, IndexConfiguration indexConfiguration, RetryConfiguration retryConfiguration) {
        Preconditions.checkNotNull((Object)connectionConfiguration, (Object)"connectionConfiguration cannot be null");
        Preconditions.checkNotNull((Object)indexConfiguration, (Object)"indexConfiguration cannot be null");
        Preconditions.checkNotNull((Object)retryConfiguration, (Object)"retryConfiguration cannot be null");
        this.connectionConfiguration = connectionConfiguration;
        this.indexConfiguration = indexConfiguration;
        this.retryConfiguration = retryConfiguration;
    }

    public static OpenSearchSinkConfiguration readOSConfig(OpenSearchSinkConfig openSearchSinkConfig) {
        return OpenSearchSinkConfiguration.readOSConfig(openSearchSinkConfig, null);
    }

    public static OpenSearchSinkConfiguration readOSConfig(OpenSearchSinkConfig openSearchSinkConfig, ExpressionEvaluator expressionEvaluator) {
        ConnectionConfiguration connectionConfiguration = ConnectionConfiguration.readConnectionConfiguration(openSearchSinkConfig);
        IndexConfiguration indexConfiguration = IndexConfiguration.readIndexConfig(openSearchSinkConfig, expressionEvaluator);
        RetryConfiguration retryConfiguration = RetryConfiguration.readRetryConfig(openSearchSinkConfig);
        return new OpenSearchSinkConfiguration(connectionConfiguration, indexConfiguration, retryConfiguration);
    }
}

