/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.SerializedJson;

public class BulkOperationWrapper {
    private static final Predicate<BulkOperation> IS_INDEX_OPERATION = BulkOperation::isIndex;
    private static final Predicate<BulkOperation> IS_CREATE_OPERATION = BulkOperation::isCreate;
    private static final Predicate<BulkOperation> IS_UPDATE_OPERATION = BulkOperation::isUpdate;
    private static final Predicate<BulkOperation> IS_DELETE_OPERATION = BulkOperation::isDelete;
    private static final Map<Predicate<BulkOperation>, Function<BulkOperation, Object>> BULK_OPERATION_TO_DOCUMENT_CONVERTERS = Map.of(IS_INDEX_OPERATION, operation -> operation.index().document(), IS_CREATE_OPERATION, operation -> operation.create().document());
    private static final Map<Predicate<BulkOperation>, Function<BulkOperation, String>> BULK_OPERATION_TO_INDEX_NAME_CONVERTERS = Map.of(IS_INDEX_OPERATION, operation -> operation.index().index(), IS_CREATE_OPERATION, operation -> operation.create().index(), IS_UPDATE_OPERATION, operation -> operation.update().index(), IS_DELETE_OPERATION, operation -> operation.delete().index());
    private static final Map<Predicate<BulkOperation>, Function<BulkOperation, String>> BULK_OPERATION_TO_ID_CONVERTERS = Map.of(IS_INDEX_OPERATION, operation -> operation.index().id(), IS_CREATE_OPERATION, operation -> operation.create().id(), IS_UPDATE_OPERATION, operation -> operation.update().id(), IS_DELETE_OPERATION, operation -> operation.delete().id());
    private final EventHandle eventHandle;
    private final BulkOperation bulkOperation;
    private final SerializedJson jsonNode;
    private final String queryTerm;

    public BulkOperationWrapper(BulkOperation bulkOperation) {
        this(bulkOperation, null, null, null);
    }

    public BulkOperationWrapper(BulkOperation bulkOperation, EventHandle eventHandle, SerializedJson jsonNode, String queryTerm) {
        Preconditions.checkNotNull((Object)bulkOperation);
        this.bulkOperation = bulkOperation;
        this.eventHandle = eventHandle;
        this.jsonNode = jsonNode;
        this.queryTerm = queryTerm;
    }

    public BulkOperationWrapper(BulkOperation bulkOperation, EventHandle eventHandle) {
        this(bulkOperation, eventHandle, null, null);
    }

    public BulkOperation getBulkOperation() {
        return this.bulkOperation;
    }

    public EventHandle getEventHandle() {
        return this.eventHandle;
    }

    public void releaseEventHandle(boolean result) {
        this.eventHandle.release(result);
    }

    public Object getDocument() {
        if (this.bulkOperation.isUpdate() || this.bulkOperation.isDelete()) {
            return this.jsonNode;
        }
        return this.getValueFromConverter(BULK_OPERATION_TO_DOCUMENT_CONVERTERS);
    }

    public String getTermValue() {
        return this.queryTerm;
    }

    public String getIndex() {
        return (String)this.getValueFromConverter(BULK_OPERATION_TO_INDEX_NAME_CONVERTERS);
    }

    public String getId() {
        return (String)this.getValueFromConverter(BULK_OPERATION_TO_ID_CONVERTERS);
    }

    private <T> T getValueFromConverter(Map<Predicate<BulkOperation>, Function<BulkOperation, T>> converters) {
        List values = converters.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(this.bulkOperation)).map(entry -> ((Function)entry.getValue()).apply(this.bulkOperation)).collect(Collectors.toList());
        if (values.size() != 1) {
            throw new UnsupportedOperationException("Only index or create operations are supported currently." + String.valueOf(this.bulkOperation));
        }
        return values.get(0);
    }
}

