/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Hyperparameter
implements JsonpSerializable {
    @Nullable
    private final Double absoluteImportance;
    private final String name;
    @Nullable
    private final Double relativeImportance;
    private final boolean supplied;
    private final double value;
    public static final JsonpDeserializer<Hyperparameter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Hyperparameter::setupHyperparameterDeserializer);

    private Hyperparameter(Builder builder) {
        this.absoluteImportance = builder.absoluteImportance;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.relativeImportance = builder.relativeImportance;
        this.supplied = ApiTypeHelper.requireNonNull(builder.supplied, this, "supplied");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static Hyperparameter of(Function<Builder, ObjectBuilder<Hyperparameter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Double absoluteImportance() {
        return this.absoluteImportance;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Double relativeImportance() {
        return this.relativeImportance;
    }

    public final boolean supplied() {
        return this.supplied;
    }

    public final double value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.absoluteImportance != null) {
            generator.writeKey("absolute_importance");
            generator.write(this.absoluteImportance.doubleValue());
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.relativeImportance != null) {
            generator.writeKey("relative_importance");
            generator.write(this.relativeImportance.doubleValue());
        }
        generator.writeKey("supplied");
        generator.write(this.supplied);
        generator.writeKey("value");
        generator.write(this.value);
    }

    protected static void setupHyperparameterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::absoluteImportance, JsonpDeserializer.doubleDeserializer(), "absolute_importance");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::relativeImportance, JsonpDeserializer.doubleDeserializer(), "relative_importance");
        op.add(Builder::supplied, JsonpDeserializer.booleanDeserializer(), "supplied");
        op.add(Builder::value, JsonpDeserializer.doubleDeserializer(), "value");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Hyperparameter> {
        @Nullable
        private Double absoluteImportance;
        private String name;
        @Nullable
        private Double relativeImportance;
        private Boolean supplied;
        private Double value;

        public final Builder absoluteImportance(@Nullable Double value) {
            this.absoluteImportance = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder relativeImportance(@Nullable Double value) {
            this.relativeImportance = value;
            return this;
        }

        public final Builder supplied(boolean value) {
            this.supplied = value;
            return this;
        }

        public final Builder value(double value) {
            this.value = value;
            return this;
        }

        @Override
        public Hyperparameter build() {
            this._checkSingleUse();
            return new Hyperparameter(this);
        }
    }
}

