/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class VertexInclude
implements JsonpSerializable {
    private final double boost;
    private final String term;
    public static final JsonpDeserializer<VertexInclude> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VertexInclude::setupVertexIncludeDeserializer);

    private VertexInclude(Builder builder) {
        this.boost = ApiTypeHelper.requireNonNull(builder.boost, this, "boost");
        this.term = ApiTypeHelper.requireNonNull(builder.term, this, "term");
    }

    public static VertexInclude of(Function<Builder, ObjectBuilder<VertexInclude>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double boost() {
        return this.boost;
    }

    public final String term() {
        return this.term;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("boost");
        generator.write(this.boost);
        generator.writeKey("term");
        generator.write(this.term);
    }

    protected static void setupVertexIncludeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::term, JsonpDeserializer.stringDeserializer(), "term");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<VertexInclude> {
        private Double boost;
        private String term;

        public final Builder boost(double value) {
            this.boost = value;
            return this;
        }

        public final Builder term(String value) {
            this.term = value;
            return this;
        }

        @Override
        public VertexInclude build() {
            this._checkSingleUse();
            return new VertexInclude(this);
        }
    }
}

