/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.cat.CatAnomalyDetectorColumn;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlJobsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MlJobsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowNoJobs;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final String format;
    private final List<CatAnomalyDetectorColumn> h;
    @Nullable
    private final Boolean help;
    @Nullable
    private final String jobId;
    private final List<CatAnomalyDetectorColumn> s;
    @Nullable
    private final TimeUnit time;
    @Nullable
    private final Boolean v;
    public static final Endpoint<MlJobsRequest, MlJobsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MlJobsRequest, MlJobsResponse>("es/cat.ml_jobs", request -> "GET", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (request.jobId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/anomaly_detectors");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.help != null) {
            params.put("help", String.valueOf(request.help));
        }
        if (request.allowNoJobs != null) {
            params.put("allow_no_jobs", String.valueOf(request.allowNoJobs));
        }
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (request.v != null) {
            params.put("v", String.valueOf(request.v));
        }
        if (request.format != null) {
            params.put("format", request.format);
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.time != null) {
            params.put("time", request.time.jsonValue());
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlJobsResponse._DESERIALIZER);

    private MlJobsRequest(Builder builder) {
        this.allowNoJobs = builder.allowNoJobs;
        this.allowNoMatch = builder.allowNoMatch;
        this.bytes = builder.bytes;
        this.format = builder.format;
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.help = builder.help;
        this.jobId = builder.jobId;
        this.s = ApiTypeHelper.unmodifiable(builder.s);
        this.time = builder.time;
        this.v = builder.v;
    }

    public static MlJobsRequest of(Function<Builder, ObjectBuilder<MlJobsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Deprecated
    @Nullable
    public final Boolean allowNoJobs() {
        return this.allowNoJobs;
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    public final List<CatAnomalyDetectorColumn> h() {
        return this.h;
    }

    @Nullable
    public final Boolean help() {
        return this.help;
    }

    @Nullable
    public final String jobId() {
        return this.jobId;
    }

    public final List<CatAnomalyDetectorColumn> s() {
        return this.s;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    @Nullable
    public final Boolean v() {
        return this.v;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MlJobsRequest> {
        @Nullable
        private Boolean allowNoJobs;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Bytes bytes;
        @Nullable
        private String format;
        @Nullable
        private List<CatAnomalyDetectorColumn> h;
        @Nullable
        private Boolean help;
        @Nullable
        private String jobId;
        @Nullable
        private List<CatAnomalyDetectorColumn> s;
        @Nullable
        private TimeUnit time;
        @Nullable
        private Boolean v;

        @Deprecated
        public final Builder allowNoJobs(@Nullable Boolean value) {
            this.allowNoJobs = value;
            return this;
        }

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder h(List<CatAnomalyDetectorColumn> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(CatAnomalyDetectorColumn value, CatAnomalyDetectorColumn ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder help(@Nullable Boolean value) {
            this.help = value;
            return this;
        }

        public final Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        public final Builder s(List<CatAnomalyDetectorColumn> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(CatAnomalyDetectorColumn value, CatAnomalyDetectorColumn ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        public final Builder v(@Nullable Boolean value) {
            this.v = value;
            return this;
        }

        @Override
        public MlJobsRequest build() {
            this._checkSingleUse();
            return new MlJobsRequest(this);
        }
    }
}

