/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.validation;

import lombok.NonNull;

public class PluginError {
    static final String PIPELINE_DELIMITER = ".";
    static final String PATH_TO_CAUSE_DELIMITER = ":";
    static final String CAUSED_BY_DELIMITER = " caused by: ";
    private final String pipelineName;
    private final String componentType;
    private final String pluginName;
    @NonNull
    private final Exception exception;

    public String getErrorMessage() {
        StringBuilder message = new StringBuilder();
        if (this.pipelineName != null) {
            message.append(this.pipelineName);
            message.append(PIPELINE_DELIMITER);
        }
        if (this.componentType != null) {
            message.append(this.componentType);
            message.append(PIPELINE_DELIMITER);
        }
        if (this.pluginName != null) {
            message.append(this.pluginName);
            message.append(PATH_TO_CAUSE_DELIMITER);
        }
        message.append(this.getFlattenedExceptionMessage(CAUSED_BY_DELIMITER));
        return message.toString();
    }

    private String getFlattenedExceptionMessage(String delimiter) {
        StringBuilder message = new StringBuilder();
        for (Throwable throwable = this.exception; throwable != null; throwable = throwable.getCause()) {
            if (throwable.getMessage() == null) continue;
            message.append(delimiter);
            message.append(throwable.getMessage());
        }
        return message.toString();
    }

    PluginError(String pipelineName, String componentType, String pluginName, @NonNull Exception exception) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        this.pipelineName = pipelineName;
        this.componentType = componentType;
        this.pluginName = pluginName;
        this.exception = exception;
    }

    public static PluginErrorBuilder builder() {
        return new PluginErrorBuilder();
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    @NonNull
    public Exception getException() {
        return this.exception;
    }

    public static class PluginErrorBuilder {
        private String pipelineName;
        private String componentType;
        private String pluginName;
        private Exception exception;

        PluginErrorBuilder() {
        }

        public PluginErrorBuilder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public PluginErrorBuilder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public PluginErrorBuilder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public PluginErrorBuilder exception(@NonNull Exception exception) {
            if (exception == null) {
                throw new NullPointerException("exception is marked non-null but is null");
            }
            this.exception = exception;
            return this;
        }

        public PluginError build() {
            return new PluginError(this.pipelineName, this.componentType, this.pluginName, this.exception);
        }

        public String toString() {
            return "PluginError.PluginErrorBuilder(pipelineName=" + this.pipelineName + ", componentType=" + this.componentType + ", pluginName=" + this.pluginName + ", exception=" + String.valueOf(this.exception) + ")";
        }
    }
}

