/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class EnumDeserializer
extends JsonDeserializer<Enum<?>>
implements ContextualDeserializer {
    static final String INVALID_ENUM_VALUE_ERROR_FORMAT = "Invalid value \"%s\". Valid options include %s.";
    private Class<?> enumClass;

    public EnumDeserializer() {
    }

    public EnumDeserializer(Class<?> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("The provided class is not an enum: " + enumClass.getName());
        }
        this.enumClass = enumClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        String enumValue = node.asText();
        Optional<Method> jsonCreator = this.findJsonCreatorMethod();
        Optional<Method> jsonValueMethod = this.findJsonValueMethodForClass();
        try {
            jsonCreator.ifPresent(method -> method.setAccessible(true));
            for (Object enumConstant : this.enumClass.getEnumConstants()) {
                block10: {
                    try {
                        if (jsonCreator.isPresent() && enumConstant.equals(jsonCreator.get().invoke(null, enumValue))) {
                            Enum enum_ = (Enum)enumConstant;
                            return enum_;
                        }
                        if (!jsonCreator.isEmpty() || !jsonValueMethod.isPresent() || !jsonValueMethod.get().invoke(enumConstant, new Object[0]).equals(enumValue)) break block10;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    Enum enum_ = (Enum)enumConstant;
                    return enum_;
                }
                if (!jsonCreator.isEmpty() || !jsonValueMethod.isEmpty() || !((Enum)enumConstant).name().equals(enumValue)) continue;
                Enum enum_ = (Enum)enumConstant;
                return enum_;
            }
        }
        finally {
            jsonCreator.ifPresent(method -> method.setAccessible(false));
        }
        List listOfEnums = jsonValueMethod.map(method -> Arrays.stream(this.enumClass.getEnumConstants()).map(valueEnum -> {
            try {
                return method.invoke(valueEnum, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList())).orElseGet(() -> Arrays.stream(this.enumClass.getEnumConstants()).map(valueEnum -> ((Enum)valueEnum).name()).collect(Collectors.toList()));
        throw new IllegalArgumentException(String.format(INVALID_ENUM_VALUE_ERROR_FORMAT, enumValue, listOfEnums));
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType javaType = property.getType();
        Class rawClass = javaType.getRawClass();
        return new EnumDeserializer(rawClass);
    }

    private Optional<Method> findJsonValueMethodForClass() {
        for (Method method : this.enumClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(JsonValue.class)) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private Optional<Method> findJsonCreatorMethod() {
        for (Method method : this.enumClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(JsonCreator.class)) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }
}

