/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DataPrepperDeserializationProblemHandler
extends DeserializationProblemHandler {
    @Inject
    public DataPrepperDeserializationProblemHandler() {
    }

    public Object handleWeirdStringValue(DeserializationContext ctxt, Class<?> targetType, String valueToConvert, String failureMsg) throws IOException {
        throw new IOException(String.format("Cannot deserialize value of type %s from String \"%s\": %s", ClassUtil.nameOf(targetType), valueToConvert, failureMsg));
    }

    public Object handleUnexpectedToken(DeserializationContext ctxt, JavaType targetType, JsonToken t, JsonParser p, String failureMsg) throws IOException {
        throw JsonMappingException.from((JsonParser)ctxt.getParser(), (String)String.format("Cannot deserialize value of type %s from %s.", ClassUtil.getTypeDescription((JavaType)targetType), JsonToken.valueDescFor((JsonToken)t)));
    }

    public Object handleMissingInstantiator(DeserializationContext ctxt, Class<?> instClass, ValueInstantiator valueInsta, JsonParser p, String msg) throws IOException {
        throw JsonMappingException.from((JsonParser)ctxt.getParser(), (String)String.format("Cannot deserialize '%s' into '%s'.", p.getText(), instClass.getName()));
    }
}

