/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.HostCookie;
import com.microsoft.graph.security.requests.HostCookieCollectionPage;
import com.microsoft.graph.security.requests.HostCookieCollectionRequestBuilder;
import com.microsoft.graph.security.requests.HostCookieCollectionResponse;
import com.microsoft.graph.security.requests.HostCookieRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostCookieCollectionRequest
extends BaseEntityCollectionRequest<HostCookie, HostCookieCollectionResponse, HostCookieCollectionPage> {
    public HostCookieCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostCookieCollectionResponse.class, HostCookieCollectionPage.class, HostCookieCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<HostCookie> postAsync(@Nonnull HostCookie newHostCookie) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new HostCookieRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newHostCookie);
    }

    @Nonnull
    public HostCookie post(@Nonnull HostCookie newHostCookie) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new HostCookieRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newHostCookie);
    }

    @Nonnull
    public HostCookieCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public HostCookieCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public HostCookieCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public HostCookieCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostCookieCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public HostCookieCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public HostCookieCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public HostCookieCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public HostCookieCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

