/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.HostComponent;
import com.microsoft.graph.security.requests.HostComponentCollectionPage;
import com.microsoft.graph.security.requests.HostComponentCollectionRequestBuilder;
import com.microsoft.graph.security.requests.HostComponentCollectionResponse;
import com.microsoft.graph.security.requests.HostComponentRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostComponentCollectionRequest
extends BaseEntityCollectionRequest<HostComponent, HostComponentCollectionResponse, HostComponentCollectionPage> {
    public HostComponentCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostComponentCollectionResponse.class, HostComponentCollectionPage.class, HostComponentCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<HostComponent> postAsync(@Nonnull HostComponent newHostComponent) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new HostComponentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newHostComponent);
    }

    @Nonnull
    public HostComponent post(@Nonnull HostComponent newHostComponent) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new HostComponentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newHostComponent);
    }

    @Nonnull
    public HostComponentCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public HostComponentCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public HostComponentCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public HostComponentCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostComponentCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public HostComponentCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public HostComponentCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public HostComponentCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public HostComponentCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

