/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Workbook;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkbookRequest
extends BaseRequest<Workbook> {
    public WorkbookRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Workbook.class);
    }

    @Nonnull
    public CompletableFuture<Workbook> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Workbook get() throws ClientException {
        return (Workbook)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Workbook> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Workbook delete() throws ClientException {
        return (Workbook)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Workbook> patchAsync(@Nonnull Workbook sourceWorkbook) {
        return this.sendAsync(HttpMethod.PATCH, sourceWorkbook);
    }

    @Nullable
    public Workbook patch(@Nonnull Workbook sourceWorkbook) throws ClientException {
        return (Workbook)this.send(HttpMethod.PATCH, sourceWorkbook);
    }

    @Nonnull
    public CompletableFuture<Workbook> postAsync(@Nonnull Workbook newWorkbook) {
        return this.sendAsync(HttpMethod.POST, newWorkbook);
    }

    @Nullable
    public Workbook post(@Nonnull Workbook newWorkbook) throws ClientException {
        return (Workbook)this.send(HttpMethod.POST, newWorkbook);
    }

    @Nonnull
    public CompletableFuture<Workbook> putAsync(@Nonnull Workbook newWorkbook) {
        return this.sendAsync(HttpMethod.PUT, newWorkbook);
    }

    @Nullable
    public Workbook put(@Nonnull Workbook newWorkbook) throws ClientException {
        return (Workbook)this.send(HttpMethod.PUT, newWorkbook);
    }

    @Nonnull
    public WorkbookRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public WorkbookRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

