/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.PrintConnector;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrintConnectorReferenceRequest
extends BaseReferenceRequest<PrintConnector> {
    public PrintConnectorReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintConnector.class);
    }

    @Nonnull
    public PrintConnectorReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PrintConnectorReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<PrintConnector> putAsync(@Nonnull PrintConnector srcPrintConnector) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/print/connectors/" + srcPrintConnector.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public PrintConnector put(@Nonnull PrintConnector srcPrintConnector) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/print/connectors/" + srcPrintConnector.id));
        return (PrintConnector)this.send(HttpMethod.PUT, payload);
    }
}

